 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS]
GO
--EXEC P_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS '2017-09-01','2017-12-31',0,1
CREATE PROCEDURE [dbo].[P_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS] @DT_INI DATETIME=NULL,@DT_FIM DATETIME=NULL, @CD_FILIAL_PAR INT=0, @FLAG_NAO_TOTALIZAR INT=0 AS 
SET NOCOUNT ON
SET ANSI_WARNINGS OFF; 
IF @DT_INI IS NULL
begin
	SELECT @DT_INI=convert(char(10),getdate(),112)
	SELECT @DT_FIM=convert(char(10),@DT_INI-7,112)
end

DECLARE @CD_FILIAL INT
DECLARE cfiliaisDanfeProvi CURSOR FAST_FORWARD FOR 
		SELECT CD_FILIAL 
		FROM PRC_FILIAL 
		WHERE
			CD_EMP =1
			AND CD_FILIAL=CASE WHEN @CD_FILIAL_PAR>0 THEN @CD_FILIAL_PAR ELSE CD_FILIAL END
		ORDER BY 
			CD_FILIAL

OPEN cfiliaisDanfeProvi
FETCH NEXT FROM cfiliaisDanfeProvi INTO @CD_FILIAL
	WHILE @@FETCH_STATUS=0
	  begin
		PRINT 'Filial ' + CONVERT(VARCHAR, @CD_FILIAL) + ' ' + CONVERT(VARCHAR, GETDATE (),108)
		UPDATE
			EST_NF_ENT_IT
		SET
			EST_NF_ENT_IT.VLR_BASE_ICMS = V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.VLR_PROD_BASE_ICMS, 
			EST_NF_ENT_IT.VLR_ICMS_IT = V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.VLR_PROD_ICMS, 
			EST_NF_ENT_IT.VLR_BASE_SUBS = V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.VLR_PROD_BASE_ST, 
			EST_NF_ENT_IT.VLR_ICMS_SUBS = V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.VLR_PROD_ICMS_ST,
			EST_NF_ENT_IT.VLR_DESC = V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.VLR_PROD_DESC,
			EST_NF_ENT_IT.VLR_PROD_FRETE=V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.VLR_PROD_FRETE,
			EST_NF_ENT_IT.ALIQ_ICMS = V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.PERC_PROD_ICMS,
			EST_NF_ENT_IT.VLR_BASE_ICMS_RET= V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.VLR_BASE_ICMS_RET, 
			EST_NF_ENT_IT.VLR_ICMS_RET=V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.VLR_ICMS_RET
		FROM         
			V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS INNER JOIN EST_NF_ENT_IT ON 
			V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.CD_EMP = EST_NF_ENT_IT.CD_EMP AND 
			V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL AND 
			V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.CD_NF = EST_NF_ENT_IT.CD_NF AND 
			V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.CD_PROD = EST_NF_ENT_IT.CD_PROD
		WHERE	
			EST_NF_ENT_IT.CD_EMP = 1
			AND EST_NF_ENT_IT.CD_FILIAL=@CD_FILIAL
			AND EST_NF_ENT_IT.DT_ENT BETWEEN @DT_INI AND @DT_FIM
			AND (
			V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.VLR_PROD_BASE_ICMS <> EST_NF_ENT_IT.VLR_BASE_ICMS
			OR  V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.VLR_PROD_ICMS <> EST_NF_ENT_IT.VLR_ICMS_IT
			OR V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.VLR_PROD_BASE_ST <> EST_NF_ENT_IT.VLR_BASE_SUBS
			OR V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.VLR_PROD_ICMS_ST <> EST_NF_ENT_IT.VLR_ICMS_SUBS
			OR V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.VLR_PROD_BASE_ICMS <> EST_NF_ENT_IT.VLR_BASE_ICMS
			OR V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.VLR_PROD_DESC <> EST_NF_ENT_IT.VLR_DESC
			OR V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.VLR_PROD_FRETE <> EST_NF_ENT_IT.VLR_PROD_FRETE
			OR V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.PERC_PROD_ICMS <> EST_NF_ENT_IT.ALIQ_ICMS 
			OR V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.VLR_BASE_ICMS_RET <> EST_NF_ENT_IT.VLR_BASE_ICMS_RET 
			OR V_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_ITENS.VLR_ICMS_RET <> EST_NF_ENT_IT.VLR_ICMS_RET);

		IF @FLAG_NAO_TOTALIZAR=0
		BEGIN
			PRINT 'Corrigir total nota fiscal '  + CONVERT(VARCHAR, GETDATE (),108)
			EXEC P_EST_NF_ENT_ANALISE_VALOR_NOTA_FISCAL @DT_INI,@DT_FIM,@CD_FILIAL,0,0;
		
			PRINT 'Corrigir custo medio produtos ' + CONVERT(VARCHAR, GETDATE (),108)
			EXEC P_EST_NF_ENT_IT_RECALCULO_CUSTO 1,@CD_FILIAL,0,0,1,@DT_INI,@DT_FIM,0;
		END
		FETCH NEXT FROM cfiliaisDanfeProvi INTO @CD_FILIAL
	  end

PRINT 'Concluido.'
CLOSE cfiliaisDanfeProvi;
DEALLOCATE cfiliaisDanfeProvi;


